// fpurge.cpp : Defines the entry point for the console application.
//


//
//  Author: Mihail Zaharenkov <mzaharenkov@mail.ru>
//
//
//   :
//
//		1.     
//
//
//



#include "stdafx.h"
#include "fpurge.h"
#include <direct.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only application object

CWinApp theApp;
bool Recurse = false;
int count_del_file = 0;

using namespace std;

BOOL CheakFullAccessToFile(LPCTSTR FileName)
{
	CFileException *pError = new CFileException;
	CFile aFile;

	//      
	//   -  FALSE
	BOOL bRet = aFile.Open(FileName, CFile::shareExclusive, pError);
	pError->Delete();
		
	//    -   
	if (!bRet)
		return false;
		
	//  
	aFile.Close();

	return true;
}

BOOL DirectoryExists(LPCTSTR lpszDir)
{
	CString strPathName = lpszDir;
	if (strPathName.GetLength () == 3)
	{
		if(strPathName[1] != ':' || strPathName[2] != '\\')
			return FALSE;

		if(GetDriveType(strPathName) != DRIVE_NO_ROOT_DIR)
			return TRUE;
	}

	if(strPathName.Right(1) == '\\')
		strPathName.Delete(strPathName.GetLength()-1);

	CFileStatus TempStatus;
	if(CFile::GetStatus(strPathName, TempStatus))
	{
		if (TempStatus.m_attribute & CFile::directory)
		{
			//file exists, and is a directory
			return TRUE;
		}
		else //not a directory
			return FALSE;
	}
	else //file doesn't exist
		return FALSE;
}

BOOL CheakDate(CString FileName, int Day)
{
	CFileException *pError = new CFileException;
	CFile aFile;

	BOOL bRet = aFile.Open(FileName, CFile::modeRead, pError);
	pError->Delete();
		
	//    -   
	if (!bRet) {
		cout << "Cannot open file: " << (LPCTSTR)FileName << endl;
		return false;
	}

	CFileStatus rStatus;
	if (!aFile.GetStatus(rStatus)) {
		cout << "Error in BOOL CheakDate(CString FileName, int Day)" << endl;
		aFile.Close();
		return false;
	}

	CTime CreateFileTime = rStatus.m_ctime;
	
	int tDay = 0;
	CTimeSpan OneDay(1,0,0,0);
	
	while (CreateFileTime <= CTime::GetCurrentTime())
	{
		tDay++;
		CreateFileTime += OneDay;
	}

	if (tDay > Day)
		return true;
		
	//  
	aFile.Close();
	
	return false;
}

void DeleteFile(CString FileName)
{
	TRY
	{
		//  
		//     -  
//		CFile::Remove((LPCTSTR)FileName);
		cout << "Delete file: " << (LPCTSTR)FileName << endl;
		count_del_file++;
	}
	CATCH( CFileException, e )
	{
		#ifdef _DEBUG
			afxDump << "File " << FileName << " cannot be removed\n";
		#endif
		cout << "File " << FileName << " cannot be removed." << endl;
	}
	END_CATCH
}

BOOL CheakFile(CString FileName)
{	
	if (FileName.FindOneOf(_T(".*?")) != -1)
		return true;

	CFileFind fileFind;
	if (fileFind.FindFile(FileName) && !DirectoryExists(LPCTSTR(FileName)))
		return true;
	
	return false;
}

void purge(CString Path,int Day)
{
	Path.TrimRight("\\");
	CFileFind ff;
	BOOL b;
	
	if (CheakFile(Path))
		//   
		b = ff.FindFile(Path);
	else
		// 
		b = ff.FindFile(Path + "\\*");
	
	CStringArray folders;
	BOOL err = TRUE;

	while (b)
	{
		b = ff.FindNextFile();
		if (ff.IsDots())
			continue;
		if (ff.IsDirectory())
		{
			folders.Add(ff.GetFilePath());
		}
		else
		{
			if (CheakDate(ff.GetFilePath(),Day))
			{
				if (CheakFullAccessToFile((LPCTSTR)ff.GetFilePath()))
					DeleteFile(ff.GetFilePath());
				else 
					cout << "Cannot delete file: " << (LPCTSTR)ff.GetFilePath() << endl;
			}
		}
	}

	if (Recurse)
	{
		//   
		for (int i = 0; i < folders.GetSize(); i++)
		{
			purge(folders[i],Day);
		}
	}

}

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
		nRetCode = 1;
	}
	else
	{

		DWORD dwArgc;
		LPTSTR *lpszArgv;

		#ifdef UNICODE
			lpszArgv = CommandLineToArgvW(GetCommandLineW(), &(dwArgc) );
		#else
			dwArgc   = (DWORD) argc;
			lpszArgv = argv;
		#endif

		
		if (dwArgc < 2)
		{
			cout << "Required parameter missing" << endl;
			cout <<  endl;
			cout << "fpurge -Ddays [\\\\server\\dir|Disk:\\dir][file_maska] [-r]" << endl;
			cout <<  endl;
			cout << "days       - number of day" << endl;
			cout << "file_maska - maska of filename (*/?)" << endl;
			cout <<  endl;
		}
		else
		{
			int i;
			int Day = 32768;
			
			// GetCurDir
			char curDir[MAX_PATH];
			GetCurrentDirectory(MAX_PATH,curDir);
			CString Path = curDir;


			//   "-d";
			for (i = 1; i < dwArgc; i++) {
				if ((((CString)lpszArgv[i]).Find((LPCTSTR)"-d") != -1) || (((CString)lpszArgv[i]).Find((LPCTSTR)"-D") != -1))
					Day = atoi(((CString)lpszArgv[i]).Mid(2));
			}
			
			//   Path
			for (i=1; i<= dwArgc; i++) {
				if ((((CString)lpszArgv[i]).Find((LPCTSTR)"\\\\") != -1) || (((CString)lpszArgv[i]).Find((LPCTSTR)":\\") != -1)) {
					Path = lpszArgv[i];
				}
				else {
					CFileFind fileFind;
					Path.TrimRight("\\");
					if ((((CString)lpszArgv[i]).FindOneOf(_T("*.?")) != -1) || (fileFind.FindFile(Path + "\\" + lpszArgv[i])))
					{
						Path += "\\";
						Path += lpszArgv[i];
					}
				}
			}

			//   "-r";
			for (i=1; i<= dwArgc; i++) {
				if ((((CString)lpszArgv[i]).Find((LPCTSTR)"-r") != -1) || (((CString)lpszArgv[i]).Find((LPCTSTR)"-R") != -1))
					Recurse = true;
			}

			purge(Path,Day);

			CString Res;
			Res.Format("     %d file(s) deleted.",count_del_file);
			cout << (LPCTSTR)Res << endl;
		}

	}

	return nRetCode;
}


