// fpurge.cpp : Defines the entry point for the console application.
//
//  Purpose: Delete old files
//
//  Usage  : fpurge -Ddays [FullPath][filename] [-r]
//
//           days     = no. of days (expiration term)
//
//           FullPath = \\server\dir | Disk:\dir
//
//           filename = name of the file(s) to be deleted;
//                      Extension and willcards allowed.
//           -r       = recurse; action applied to all subfolders
//
//  Action : pgm looks up the creation date for given file name
//           (or FILES if willcards present);
//           If the difference (CurrentDate - Date_of_Create) > No. of days
//           then the file will be deleted;
//           Pgm will apply this rule to all subfolders if option -r present
//
//
//  Messages: Name of deleted files on standard output;
//            Error message appears when can not delete a file;
//            Error message when a file can not be open (possible locked)
//
//  Environment: pgm runs under MSDOS / Win2000 / WindowsXP / Windows98
//               Standard piping is allowed
//
//  Author: Mihail Zaharenkov <mzaharenkov@mail.ru>
//
//  --------------------------------------------------------------------------
//  Revision history:
//
//  2003/08/18 M.Z. New pgm; a dot <.> does not allowed in foldername
//  2003/08/19 A.B. Fixed pointer to FileName in function DeleteFile;
//                  Welcome message replaced. Compiled with MVC++ (VS60)
//  2003/08/20 M.Z. Fixed: "a dot <.> does not allowed in foldername"
//  2003/08/20 A.B. Recursive does not work properly when 2nd arg = path\*.ext 
//  --------------------------------------------------------------------------

#include "stdafx.h"
#include "fpurge.h"
#include <direct.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only application object

CWinApp theApp;
bool Recurse = false;
int count_del_file = 0;
// 2004_04_22
bool move = false;
CString move_path = "";
bool overwrite = false;
// 2004_04_22

using namespace std;

BOOL CheckFullAccessToFile(LPCTSTR FileName)
{
    CFileException *pError = new CFileException;
    CFile aFile;

    // Try to open file with full access,
    // Return FALSE if not successful
    BOOL bRet = aFile.Open(FileName, CFile::shareExclusive, pError);
    pError->Delete();

    // If got error then exit with error
    if (!bRet)
        return false;

    // Close file
    aFile.Close();

    return true;
}

BOOL DirectoryExists(LPCTSTR lpszDir)
{
    CString strPathName = lpszDir;
    if (strPathName.GetLength () == 3)
    {
        if(strPathName[1] != ':' || strPathName[2] != '\\')
            return FALSE;

        if(GetDriveType(strPathName) != DRIVE_NO_ROOT_DIR)
            return TRUE;
    }

    if(strPathName.Right(1) == '\\')
        strPathName.Delete(strPathName.GetLength()-1);

    CFileStatus TempStatus;
    if(CFile::GetStatus(strPathName, TempStatus))
    {
        if (TempStatus.m_attribute & CFile::directory)
        {
            //file exists, and is a directory
            return TRUE;
        }
        else //not a directory
            return FALSE;
    }
    else //file doesn't exist
        return FALSE;
}


int FileExist(LPCTSTR FileName)
{
	CFileFind fileFind;
	if (!fileFind.FindFile(FileName))
	{
		if (DirectoryExists(FileName))  // if root ex. "C:\"
			return -1;
		return 0;
	}
	fileFind.FindNextFile();
	return fileFind.IsDirectory() ? -1 : 1;
}


BOOL CheckDate(CString FileName, int Day)
{
    CFileException *pError = new CFileException;
    CFile aFile;

    BOOL bRet = aFile.Open(FileName, CFile::modeRead, pError);
    pError->Delete();

    // Exit with error if error found while open file
    if (!bRet) {
        cout << "Cannot open file: " << (LPCTSTR)FileName << endl;
        return false;
    }

    CFileStatus rStatus;
    if (!aFile.GetStatus(rStatus)) {
        cout << "Error in BOOL CheckDate(CString FileName, int Day)" << endl;
        aFile.Close();
        return false;
    }

    CTime CreateFileTime = rStatus.m_ctime;

    int tDay = 0;
    CTimeSpan OneDay(1,0,0,0);

    while (CreateFileTime <= CTime::GetCurrentTime())
    {
        tDay++;
        CreateFileTime += OneDay;
    }

    if (tDay > Day)
        return true;

    // Close file
    aFile.Close();

    return false;
}

void DeleteFile(CString FileName)
{
// 2004_04_22
	if (!move) { // Delete
		TRY
		{
			// Delete the file;
			// If not successful then call exception procedure
		    CFile::Remove((LPCTSTR)FileName);
			cout << "Delete file: " << (LPCTSTR)FileName << endl;
			count_del_file++;
		}
		CATCH( CFileException, e )
		{
			#ifdef _DEBUG
				afxDump << "File " << (LPCTSTR)FileName << " cannot be removed\n";
			#endif
			cout << "File " << (LPCTSTR)FileName << " cannot be removed." << endl;
		}
		END_CATCH
	}
	else { // Move
		TRY
		{
			// Move the file;
			// If not successful then call exception procedure
			//      
			CFileException *pError = new CFileException;
			CFile File;
			BOOL bRet = File.Open((LPCTSTR) FileName, CFile::modeRead, pError);
			pError->Delete();

			//    - 
			if (!bRet) {
				cout << "File " << (LPCTSTR)FileName << " cannot be moved." << endl;
				return;
			}

			CString Name = File.GetFileName();
			File.Close();
			
			CString ToDir = move_path;
			ToDir.TrimRight("\\");
			ToDir += "\\" + Name;

			if (FileExist(ToDir)) {
				if (overwrite) {
					TRY
					{
						// Delete the file;
						// If not successful then call exception procedure
						CFile::Remove((LPCTSTR)ToDir);
					}
					CATCH( CFileException, e )
					{
						#ifdef _DEBUG
							afxDump << "File " << (LPCTSTR)ToDir << " cannot be removed\n";
						#endif
						cout << "File " << (LPCTSTR)ToDir << " cannot be removed." << endl;
					}
					END_CATCH
				}
				else {
					cout << "File " << (LPCTSTR)ToDir << " already exist." << endl;
					return;
				}
			}

			BOOL err = ::MoveFile((LPCTSTR)FileName, (LPCTSTR)ToDir);
			if (err) {
				cout << "Move file: " << (LPCTSTR)FileName << endl;
				count_del_file++;
			}
			else
				cout << "File " << (LPCTSTR)FileName << " cannot be moved." << endl;
		}
		CATCH( CFileException, e )
		{
			#ifdef _DEBUG
				afxDump << "File " << (LPCTSTR)FileName << " cannot be moved\n";
			#endif
			cout << "File " << (LPCTSTR)FileName << " cannot be moved." << endl;
		}
		END_CATCH
	}
// 2004_04_22
}

BOOL CheckFile(CString FileName)
{
    if (FileName.FindOneOf(_T("*?")) != -1)
        return true;

    CFileFind fileFind;
    if (fileFind.FindFile(FileName) && !DirectoryExists(LPCTSTR(FileName)))
        return true;

    return false;
}

void purge(CString Path,int Day)
{
    Path.TrimRight("\\");
    CFileFind ff;
    BOOL b;
    CStringArray folders;
    BOOL err = TRUE;
	CString maska = "";

	if (CheckFile(Path)) 
	{
        // File?
        b = ff.FindFile(Path);
		// Del file according to mask
		while (b)
		{
			b = ff.FindNextFile();
			if (ff.IsDots())
				continue;
			if (!ff.IsDirectory())
			{
				if (CheckDate(ff.GetFilePath(),Day))
				{
					if (CheckFullAccessToFile((LPCTSTR)ff.GetFilePath()))
						DeleteFile(ff.GetFilePath());
					else
					// 2004_04_22
						if (!move)
							cout << "Cannot delete file: " << (LPCTSTR)ff.GetFilePath() << endl;
						else
							cout << "Cannot move file: " << (LPCTSTR)ff.GetFilePath() << endl;
					// 2004_04_22
				}
			}
		}
	    // Finding sub dir
		if (Recurse)
		{
			while (((Path.Right(1) != "\\") && (Path.Right(1) != "/")) && (Path.GetLength()>0))
			{
				maska = Path.Right(1) + maska;
				Path.Delete(Path.GetLength()-1,1);
			}
			Path.TrimRight("\\");
			b = ff.FindFile(Path + "\\*");
			while (b)
			{
				b = ff.FindNextFile();
				if (ff.IsDots())
					continue;
				if (ff.IsDirectory())
					folders.Add(ff.GetFilePath());
			}
		}

	}
    else 
	{
        // or Folder?
        b = ff.FindFile(Path + "\\*");
		while (b)
		{
			b = ff.FindNextFile();
			if (ff.IsDots())
				continue;
			if (ff.IsDirectory())
			{
				folders.Add(ff.GetFilePath());
			}
			else
			{
				if (CheckDate(ff.GetFilePath(),Day))
				{
					if (CheckFullAccessToFile((LPCTSTR)ff.GetFilePath()))
						DeleteFile(ff.GetFilePath());
					else
						cout << "Cannot delete file: " << (LPCTSTR)ff.GetFilePath() << endl;
				}
			}
		}
	}


    if (Recurse)
    {
        // Apply to all subfolders
        for (int i = 0; i < folders.GetSize(); i++)
        {
            purge(folders[i]+"\\" + maska,Day);
        }
    }
}

void print_help()
{
    cout << "   fpurge: purge expired files. V.1.0. Usage:" << endl;
    cout <<  endl;
    cout << "         fpurge -Ddays [FullPath][filename] [-r] [-m:move_path] [-Y]" << endl;
    cout <<  endl;
    cout << "      days  - number of days (expiration term) " << endl;
    cout << "      file  - filename (willcards */? allowed)" << endl;
    cout << "      -r    - recurse subdirectories" << endl;
    cout << "   Examples:" << endl;
    cout << "   ---------" << endl;
    cout << "              fpurge -d90 \\\\Server\\Archive\\*.zip " << endl;
    cout << "   will delete all files *.zip older than three months from Server\\Archive " << endl;
    cout << "   " << endl;
    cout << "             fpurge -d1 \"C:\\Windows\\Temporary Internet Files\\XXX*.jpg\" -r" << endl;
    cout << "   will delete more than one day old JPG files, name starting with XXX," << endl;
    cout << "   from Internet Explorer temporary folders and subfolders" << endl;
    cout <<  endl;
    cout << "             fpurge -d365 -r" << endl;
    cout << "   will delete all files older than one year from current folder and subfolders " << endl;
    cout <<  endl;
}

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
    int nRetCode = 0;

    // initialize MFC and print and error on failure
    if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
    {
        cerr << _T("Fatal Error: MFC initialization failed") << endl;
        nRetCode = 1;
    }
    else
    {

        DWORD dwArgc;
        LPTSTR *lpszArgv;

        #ifdef UNICODE
            lpszArgv = CommandLineToArgvW(GetCommandLineW(), &(dwArgc) );
        #else
            dwArgc   = (DWORD) argc;
            lpszArgv = argv;
        #endif


        if (dwArgc < 2)
        {
			print_help();
        }
        else
        {
            int i;
            int Day = 32768;
			bool find_path = false;

            // GetCurDir
            char curDir[MAX_PATH];
            GetCurrentDirectory(MAX_PATH,curDir);
            CString Path = curDir;


            // Looking for option "-d";
            for (i = 1; i < dwArgc; i++) {
                if ((((CString)lpszArgv[i]).Find((LPCTSTR)"-d") != -1) || (((CString)lpszArgv[i]).Find((LPCTSTR)"-D") != -1))
                    Day = atoi(((CString)lpszArgv[i]).Mid(2));
            }

// 2004_04_22
            // Looking for option "-m:path";
            for (i = 1; i < dwArgc; i++) {
                if ((((CString)lpszArgv[i]).Find((LPCTSTR)"-m:") != -1) || (((CString)lpszArgv[i]).Find((LPCTSTR)"-M:") != -1)) {
                    move = true;
					move_path = ((CString)lpszArgv[i]).Right(((CString)lpszArgv[i]).GetLength()-3);
					if (!DirectoryExists(move_path))
					{
						cout << "   Path don't find (-m:move_path)" << endl << endl;
						print_help();
					}
				}
            }
            // Looking for option "/Y";
            for (i = 1; i < dwArgc; i++) {
                if ((((CString)lpszArgv[i]).Find((LPCTSTR)"-Y") != -1) || (((CString)lpszArgv[i]).Find((LPCTSTR)"-y:") != -1)) {
                    overwrite = true;
				}
            }
// 2004_04_22

            // Looking for Path
            for (i=1; i<= dwArgc; i++) {
// 2004_04_22
                if ((((CString)lpszArgv[i]).Find((LPCTSTR)"-m:") != -1) || (((CString)lpszArgv[i]).Find((LPCTSTR)"-M:") != -1)) {
					continue;
				}

// 2004_04_22
				if ((((CString)lpszArgv[i]).Find((LPCTSTR)"\\\\") != -1) || (((CString)lpszArgv[i]).Find((LPCTSTR)":\\") != -1)) {
                    Path = lpszArgv[i];
					find_path = true;
                }
                else {
                    CFileFind fileFind;
                    Path.TrimRight("\\");
                    if ((((CString)lpszArgv[i]).FindOneOf(_T("*?")) != -1) || (fileFind.FindFile(Path + "\\" + lpszArgv[i])))
                    {
                        Path += "\\";
                        Path += lpszArgv[i];
						find_path = true;
                    }
                }
            }

            // Looking for option  "-r";
            for (i=1; i<= dwArgc; i++) {
                if ((((CString)lpszArgv[i]).Find((LPCTSTR)"-r") != -1) || (((CString)lpszArgv[i]).Find((LPCTSTR)"-R") != -1))
                    Recurse = true;
            }

            if (find_path)
				purge(Path,Day);
			else
			{
			    cout << "   Path don't find" << endl << endl;
				print_help();
			}

            CString Res;
			// 2004_04_22            
			if (!move)
				Res.Format("     %d file(s) deleted.",count_del_file);
			else
				Res.Format("     %d file(s) moved.",count_del_file);
			// 2004_04_22            
            cout << (LPCTSTR)Res << endl;
        }

    }

    return nRetCode;
}

